<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="LabResultsInterpretation.aspx.cs" Inherits="LabResultsInterpretation"%>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

     <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text = "My Tasks > Interpretation & Follow Up > "/>
              <br />
    </div>
    
    <div class = "excludeSaveWarnings">
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>    
    <asp:GridView ID="GridViewLabResultsIntrprtn" runat="server" AllowPaging="True" OnRowCommand="SelectActivity" 
        AutoGenerateColumns="False"  DataKeyNames="CaseId,CaseTypeId" PageSize = "20" AllowSorting="true"  >
        <Columns>
            
            <asp:BoundField DataField="CaseId" HeaderText="Workflow ID" SortExpression="WKF_CASE_ID"/>
            <asp:TemplateField HeaderText="Patient Name" SortExpression="WKF_CASE.PATIENT.LAST_NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression="WKF_CASE.REFERRAL.STD_INSTITUTION.STATIONNUMBER">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSite" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("StationNumber")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Facility" SortExpression="WKF_CASE.REFERRAL.STD_INSTITUTION.NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelFacility" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Institution")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Specimen Type" SortExpression="WKF_CASE.STD_WKFCASETYPE.Name">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseType")), false) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <br />
    <table>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersProviderBio" 
        Text = "Print Completed Provider Letters - Biological Monitoring" 
         onclick="ButtonPrintLettersProviderBio_Click" />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersPatientBio" 
        Text = "Print Completed Patient Letters - Biological Monitoring" 
         onclick="ButtonPrintLettersPatientBio_Click" />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersProviderFrag" 
        Text = "Print Completed Provider Letters - Fragment Analysis" 
         onclick="ButtonPrintLettersProviderFrag_Click"   />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersPatientFrag" 
        Text = "Print Completed Patient Letters - Fragment Analysis" 
         onclick="ButtonPrintLettersPatientFrag_Click"  />
    </td>
    </tr>
    </table>
    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
        SelectMethod="GetInterpretationActivities" 
        SelectCountMethod="GetInterpretationActivitiesCount" 
        EnablePaging="True"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        onselected="ObjectDataSource1_Selected" 
        TypeName="VeteransAffairs.Registries.BusinessManager.LabResultsIntrprtnManager" 
        OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="6" Name="status" 
                QueryStringField="OrderType" Type="Object" />
            <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>

